/*
 * Created on Aug 1, 2003
 */
package Interface;

import Data.*;
import DatabaseCommunication.*;
import Validators.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.util.Date;
import java.sql.*;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;

/**
 * @author student
 * This class is being used for implement the availability functionality of the user"Me".
 */
public class TabMe extends JFrame implements ActionListener {

	final static JLabel adLabel = new JLabel("I will be out : ");
	final static String STRINGONE = "The Rest of the Day";
	final static String STRINGTWO = "From now Until ";
	final static String STRINGTHREE = "From";
	final static String STRINGFOUR = "All day tomorrow";

	static JLabel message = new JLabel();
	static JPanel adPanel = new JPanel();

	static JTextField untill2hr = new JTextField(3);
	static JTextField untill2min = new JTextField(3);
	//	static JComboBox untill2amPm = new JComboBox();

	static JTextField untill3hr = new JTextField(3);
	static JTextField untill3min = new JTextField(3);
	//	static JComboBox untill3amPm = new JComboBox();
	static JTextField from3hr = new JTextField(3);
	static JTextField from3min = new JTextField(3);
	//	static JComboBox from3amPm = new JComboBox();

	static JRadioButton one = new JRadioButton(STRINGONE);
	static JRadioButton two = new JRadioButton(STRINGTWO);
	static JRadioButton three = new JRadioButton(STRINGTHREE);
	static JRadioButton four = new JRadioButton(STRINGFOUR);

	static JLabel note =
		new JLabel("Note: All times must be specified using a 24 hr clock.");

	private static UserData user = new UserData();

	/**
	 * This is the constructor for TabMe.java
	 */
	public TabMe() {
		super();

	}
	/**
	 * This is the constructor for TabMe.java for a particular user
	 */
	public TabMe(UserData user) {
		this.user = user;

	}
	/**
	 * This method is being used to create Me Tab
	 * @return JPanel
	 */
	public  JPanel createTabMe() {

		JPanel aPanel = new JPanel();
		JPanel titledBorders = new JPanel();

		TitledBorder advertiseTitled =
			BorderFactory.createTitledBorder("Advertise Availability");
		adPanel.setBorder(advertiseTitled);
		adPanel.setLayout(new BoxLayout(adPanel, BoxLayout.Y_AXIS));
		adPanel.setLayout(new GridLayout(0, 1));

		adPanel.add(adLabel, JLabel.CENTER);

		note.setHorizontalAlignment(SwingConstants.CENTER);
		note.setBackground(Color.RED);
		adPanel.add(note);

		one.setMnemonic(KeyEvent.VK_B);
		one.setActionCommand(STRINGONE);
		one.setSelected(true);

		two.setMnemonic(KeyEvent.VK_C);
		two.setActionCommand(STRINGTWO);

		three.setMnemonic(KeyEvent.VK_D);
		three.setActionCommand(STRINGTHREE);

		four.setMnemonic(KeyEvent.VK_R);
		four.setActionCommand(STRINGFOUR);

		//		Group the radio buttons.
		ButtonGroup group = new ButtonGroup();
		group.add(one);
		group.add(two);
		group.add(three);
		group.add(four);

		//		Register a listener for the radio buttons.
		one.addActionListener(this);
		two.addActionListener(this);
		three.addActionListener(this);
		four.addActionListener(this);

		JPanel onePanel = new JPanel();
		onePanel.add(one);

		JPanel twoPanel = new JPanel();
		twoPanel.setLayout(new FlowLayout());
		twoPanel.add(two);
		twoPanel.add(untill2hr);
		twoPanel.add(new JLabel(":"));
		twoPanel.add(untill2min);
		//		twoPanel.add(untill2amPm);

		JPanel threePanel = new JPanel();
		threePanel.setLayout(new FlowLayout());
		threePanel.add(three);
		threePanel.add(from3hr);
		threePanel.add(new JLabel(":"));
		threePanel.add(from3min);
		//		threePanel.add(from3amPm);
		threePanel.add(new JLabel("until"));
		threePanel.add(untill3hr);
		threePanel.add(new JLabel(":"));
		threePanel.add(untill3min);
		//		threePanel.add(untill3amPm);

		JPanel fourPanel = new JPanel();
		fourPanel.add(four);

		adPanel.add(onePanel);
		adPanel.add(twoPanel);
		adPanel.add(threePanel);
		adPanel.add(fourPanel);

		titledBorders.add(adPanel);

		aPanel.add(titledBorders, BorderLayout.WEST);

		JPanel btnPanel = new JPanel();

		JButton ok = new JButton("OK");
		ok.setActionCommand("ok");
		ok.addActionListener(this);

		JButton cancel = new JButton("Cancel");
		cancel.setActionCommand("cancel");
		cancel.addActionListener(this);

		JButton exit = new JButton("Log out");
		exit.setActionCommand("logout");
		exit.addActionListener(this);

		btnPanel.add(ok);
		btnPanel.add(cancel);
		btnPanel.add(exit);

		adPanel.add(btnPanel);

		message.setPreferredSize(new Dimension(250, 50));
		message.setHorizontalAlignment(SwingConstants.CENTER);

		adPanel.add(message);

		return adPanel;

	}

	public void actionPerformed(ActionEvent e) {

		String command = e.getActionCommand();
		if (command == "ok") {

			if (one.isSelected() == true) {
				////set user properties				
				setUserDetails();
				////get the current time 				
				long currentTime = System.currentTimeMillis();
				Timestamp timestamp = new Timestamp(currentTime);
				user.setOutFrom(timestamp);
				System.out.println("User outfrom " + timestamp);
				////calculate endtime date
				long endTime = addDays(new Date(System.currentTimeMillis()), 1);
				Timestamp untill = new Timestamp(endTime);
				untill.setHours(0);
				untill.setMinutes(0);
				untill.setSeconds(0);
				untill.setNanos(0);
				user.setOutTo(untill);
				System.out.println("User outTo" + untill);
				////update the database
				updateDatabase();

			} else if (two.isSelected() == true) {

				////set user properties				
				setUserDetails();

				////get the current time	
				long currentTime = System.currentTimeMillis();
				user.setOutFrom(new Timestamp(currentTime));
				System.out.println("User outFrom " + user.getOutFrom());

				////calculate end timestamp from now
				Timestamp timestamp = new Timestamp(currentTime);
				timestamp.setHours(Integer.parseInt(untill2hr.getText()));
				timestamp.setMinutes(Integer.parseInt(untill2min.getText()));
				user.setOutTo(timestamp);
				System.out.println("User outTo " + user.getOutTo());

				////update the database
				updateDatabase();
			} else if (three.isSelected() == true) {

				////set user properties
				setUserDetails();

				////get the from timestamp	
				long currentTime = System.currentTimeMillis();
				Timestamp from = new Timestamp(currentTime);
				from.setHours(Integer.parseInt(from3hr.getText()));
				from.setMinutes(Integer.parseInt(from3min.getText()));
				user.setOutFrom(from);
				System.out.println("User outFrom " + user.getOutFrom());

				////calculate end timestamp from now
				Timestamp end = new Timestamp(currentTime);
				end.setHours(Integer.parseInt(untill3hr.getText()));
				end.setMinutes(Integer.parseInt(untill3min.getText()));
				user.setOutTo(end);
				System.out.println("User outTo " + user.getOutTo());

				////update the database
				updateDatabase();

			} else if (four.isSelected() == true) {

				////set user properties
				setUserDetails();

				////calculate the start time stamp	 
				long from = addDays(new Date(System.currentTimeMillis()), 1);
				Timestamp fromTime = new Timestamp(from);
				fromTime.setHours(0);
				fromTime.setMinutes(0);
				fromTime.setSeconds(0);
				fromTime.setNanos(0);
				user.setOutFrom(fromTime);
				System.out.println("User outFrom " + user.getOutFrom());

				////calculate end timestamp from now
				long end = addDays(new Date(System.currentTimeMillis()), 2);
				Timestamp endTime = new Timestamp(end);
				endTime.setHours(0);
				endTime.setMinutes(0);
				endTime.setSeconds(0);
				endTime.setNanos(0);
				user.setOutTo(endTime);
				System.out.println("User outTo " + user.getOutTo());

				////update the database
				updateDatabase();
			} else {
				message.setText("Select atleast one option.");
				return;
			}

		} else if (command == "cancel") {
			one.setSelected(true);
			return;
		} else if (command == "logout") {
			this.dispose();
			System.exit(0);
		} else
			message.setText("");

	}
	/**
	 * This method is being used to set the user details
	 *  void
	 */
	public static void setUserDetails() {

		System.out.println("User loginId " + user.getLoginId());
		String loginId = user.getLoginId();
		user.setLoginId(loginId);
		System.out.println("User loginId " + user.getLoginId());
		UserManager uManager = new UserManager();
		try {
			user = uManager.selectUser(user.getLoginId());
			//message.setText("user is now inserted");
			message.setText("Request has been processed successfully.");
		} catch (Exception exp) {
			//message.setText("Error while inserting user data "+exp.toString());
			message.setText(
				"System couldnt process the request"
					+ '\n'
					+ "Please try again later.");
		}
		String fName = user.getFName();
		String lName = user.getLName();
		user.setFName(fName);
		System.out.println("User firstname " + user.getFName());
		user.setLName(lName);
		System.out.println("User lastname " + user.getLName());

	}

	/**
	 * This method is being used to update user in the database
	 *  void
	 */
	public static void updateDatabase() {

		//Checking for valid time field before updating the database
		TimeValidator timeValidator = new TimeValidator();
		boolean validTime = timeValidator.validate(user);

		if (!validTime) {
			message.setText(timeValidator.getMessage());
			return;
		}
		UserManager uManager = new UserManager();
		try {
			uManager.insertUserData(user);
			//message.setText("user is now inserted");
			message.setText("Request has been processed successfully.");
		} catch (Exception exp) {
			//message.setText("Error while inserting user data "+exp.toString());
			message.setText(
				"System couldnt process the request"
					+ '\n'
					+ "Please try again later.");
		}

	}

	/**
	 * This method is being used to add days
	 * @param startDate
	 * @param numberOfDays
	 * @return long
	 */
	public static long addDays(java.util.Date startDate, int numberOfDays) {
		GregorianCalendar cal = new GregorianCalendar();
		cal.setTime(startDate);
		cal.add(Calendar.DATE, numberOfDays);
		return cal.getTimeInMillis();

	}
	/**
	 * This method is being used to get the login Id of the user
	 * @return String
	 */
	public static String getLoginId() {
		return user.getLoginId();
	}
}
